/*
 * Decompiled with CFR 0.152.
 */
package pse.result;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pse.result.AutoSave;
import pse.result.ExamInterrupted;
import pse.result.FinalSave;
import pse.result.SessionEnd;
import pse.result.SessionStart;
import pse.result.SittingEnd;
import pse.result.SittingStart;
import pse.result.TimeStampedObject;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public abstract class SessionEvent
extends TimeStampedObject {
    protected long timeRemaining;
    protected long timeUsed;

    public boolean hasAttributes() {
        return true;
    }

    public long getTimeAllowed() {
        return this.timeRemaining + this.timeUsed;
    }

    public long getTimeRemaining() {
        return this.timeRemaining;
    }

    public void setTimeRemaining(long l) {
        this.timeRemaining = l;
    }

    public boolean hasTimeRemaining() {
        return this.timeRemaining >= 0L;
    }

    public long getTimeUsed() {
        return this.timeUsed;
    }

    public void setTimeUsed(long l) {
        this.timeUsed = l;
    }

    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addOmittableAttribute("time-remaining", this.timeRemaining, -1L);
        xmlWriter.addOmittableAttribute("time-used", this.timeUsed, -1L);
    }

    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.serverTimeString = XmlUtils.getAttribute(node, "server-time");
        this.timeRemaining = XmlUtils.getLongAttribute(node, "time-remaining", -1L);
        this.timeUsed = XmlUtils.getLongAttribute(node, "time-used", -1L);
    }

    public static SessionEvent createFromElement(Element element) {
        SessionEvent sessionEvent = null;
        String string = element.getTagName();
        if (string.equals("auto-save")) {
            sessionEvent = new AutoSave();
        } else if (string.equals("exam-interrupted")) {
            sessionEvent = new ExamInterrupted();
        } else if (string.equals("final-save")) {
            sessionEvent = new FinalSave();
        } else if (string.equals("session-end")) {
            sessionEvent = new SessionEnd();
        } else if (string.equals("session-start")) {
            sessionEvent = new SessionStart();
        } else if (string.equals("sitting-end")) {
            sessionEvent = new SittingEnd();
        } else if (string.equals("sitting-start")) {
            sessionEvent = new SittingStart();
        } else {
            throw new Error("Unrecognized tag name for SessionEvent: <" + string + ">");
        }
        sessionEvent.fromMyNode(element);
        return sessionEvent;
    }
}

